#ifndef __PROFIBUS_FSPMM_ERROR_H
#define __PROFIBUS_FSPMM_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// PROFIBUS Master FSPMM Packet Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_PROFIBUS_FSPMM_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_PROFIBUS_FSPMM_COMMAND_INVALID ((TLR_RESULT)0xC0380001L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_INV_BUSMODE
//
// MessageText:
//
//  Invalid bus mode for this command.
//
#define TLR_E_PROFIBUS_FSPMM_INV_BUSMODE ((TLR_RESULT)0xC0380002L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_RESET
//
// MessageText:
//
//  FSPMM task is reseted.
//
#define TLR_E_PROFIBUS_FSPMM_RESET       ((TLR_RESULT)0xC0380003L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_ACLR
//
// MessageText:
//
//  Profibus master is at auto clear state.
//
#define TLR_E_PROFIBUS_FSPMM_ACLR        ((TLR_RESULT)0xC0380004L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_CONTROL_TIMER_EXPIRED
//
// MessageText:
//
//  Data Control Timer expired. No bus access for sending global control.
//
#define TLR_E_PROFIBUS_FSPMM_CONTROL_TIMER_EXPIRED ((TLR_RESULT)0xC0380005L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_ALARM_OVERFLOW
//
// MessageText:
//
//  Alarm buffer overflow.
//
#define TLR_E_PROFIBUS_FSPMM_ALARM_OVERFLOW ((TLR_RESULT)0xC0380006L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_ALARM_NOT_INIT
//
// MessageText:
//
//  Alarm handler is not initialized.
//
#define TLR_E_PROFIBUS_FSPMM_ALARM_NOT_INIT ((TLR_RESULT)0xC0380007L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_ALARM_NOT_STARTED
//
// MessageText:
//
//  Alarm handler is not started.
//
#define TLR_E_PROFIBUS_FSPMM_ALARM_NOT_STARTED ((TLR_RESULT)0xC0380008L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_ALARM_NOT_ENABLED
//
// MessageText:
//
//  Alarm are disabled.
//
#define TLR_E_PROFIBUS_FSPMM_ALARM_NOT_ENABLED ((TLR_RESULT)0xC0380009L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_ALARM_NOT_PENDING
//
// MessageText:
//
//  Alarm is not at a pending state.
//
#define TLR_E_PROFIBUS_FSPMM_ALARM_NOT_PENDING ((TLR_RESULT)0xC038000AL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_ALARM_STATE_ERROR
//
// MessageText:
//
//  Invalid Alarm state.
//
#define TLR_E_PROFIBUS_FSPMM_ALARM_STATE_ERROR ((TLR_RESULT)0xC038000BL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_ALARM_SEQ_ERROR
//
// MessageText:
//
//  Alarm sequence error occurred.
//
#define TLR_E_PROFIBUS_FSPMM_ALARM_SEQ_ERROR ((TLR_RESULT)0xC038000CL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_MSAC1_STATE_ERROR
//
// MessageText:
//
//  Alarm handler is not at the prober state.
//
#define TLR_E_PROFIBUS_FSPMM_MSAC1_STATE_ERROR ((TLR_RESULT)0xC038000DL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_MSAC1_FAULT
//
// MessageText:
//
//  Get an alarm acknowledge without an alarm.
//
#define TLR_E_PROFIBUS_FSPMM_MSAC1_FAULT ((TLR_RESULT)0xC038000EL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_INVALID_AREA_CODE
//
// MessageText:
//
//  Invalid area code or slave address received.
//
#define TLR_E_PROFIBUS_FSPMM_INVALID_AREA_CODE ((TLR_RESULT)0xC038000FL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_IV_DL_DATA_LEN
//
// MessageText:
//
//  Invalid data length.
//
#define TLR_E_PROFIBUS_FSPMM_IV_DL_DATA_LEN ((TLR_RESULT)0xC0380011L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_IV_BUS_PRM
//
// MessageText:
//
//  Invalid bus parameter received.
//
#define TLR_E_PROFIBUS_FSPMM_IV_BUS_PRM  ((TLR_RESULT)0xC0380012L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_IV_SLAVE_PRM
//
// MessageText:
//
//  Invalid slave parameter received.
//
#define TLR_E_PROFIBUS_FSPMM_IV_SLAVE_PRM ((TLR_RESULT)0xC0380013L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_ACK_NO
//
// MessageText:
//
//  Command can not executed at the actual bus state.
//
#define TLR_E_PROFIBUS_FSPMM_ACK_NO      ((TLR_RESULT)0xC0380014L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_ACK_GE
//
// MessageText:
//
//  Error while sending global control.
//
#define TLR_E_PROFIBUS_FSPMM_ACK_GE      ((TLR_RESULT)0xC0380015L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_MSAL1_FAULT
//
// MessageText:
//
//  Failture at alarm handler. Alarm handler is stopped.
//
#define TLR_E_PROFIBUS_FSPMM_MSAL1_FAULT ((TLR_RESULT)0xC0380016L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_MSAC2_FAULT
//
// MessageText:
//
//  Failture at MSAC2 handler.
//
#define TLR_E_PROFIBUS_FSPMM_MSAC2_FAULT ((TLR_RESULT)0xC0380017L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_REJ_SE
//
// MessageText:
//
//  Device is stopping the communication or not in OPEN state.
//
#define TLR_E_PROFIBUS_FSPMM_REJ_SE      ((TLR_RESULT)0xC0380018L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_REJ_PS
//
// MessageText:
//
//  A previous service is still in process.
//
#define TLR_E_PROFIBUS_FSPMM_REJ_PS      ((TLR_RESULT)0xC0380019L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_REJ_LE
//
// MessageText:
//
//  Message have a invalid length.
//
#define TLR_E_PROFIBUS_FSPMM_REJ_LE      ((TLR_RESULT)0xC038001AL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_REJ_IV
//
// MessageText:
//
//  Invalid parameter at request.
//
#define TLR_E_PROFIBUS_FSPMM_REJ_IV      ((TLR_RESULT)0xC038001BL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_REJ_ABORT
//
// MessageText:
//
//  Device aborts DP V1 communication.
//
#define TLR_E_PROFIBUS_FSPMM_REJ_ABORT   ((TLR_RESULT)0xC038001CL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_INVALID_SLAVE_ADDRESS
//
// MessageText:
//
//  Invalid slave address.
//
#define TLR_E_PROFIBUS_FSPMM_INVALID_SLAVE_ADDRESS ((TLR_RESULT)0xC038001DL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_ALREADY_INITIALZED
//
// MessageText:
//
//  FSPMM Alraedy initialized.
//
#define TLR_E_PROFIBUS_FSPMM_ALREADY_INITIALZED ((TLR_RESULT)0xC038001EL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_INVALID_APPLICATION
//
// MessageText:
//
//  Command from not registerd application.
//
#define TLR_E_PROFIBUS_FSPMM_INVALID_APPLICATION ((TLR_RESULT)0xC038001FL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_DMPMM_IV_STATE
//
// MessageText:
//
//  Command not allowed in actual state.
//
#define TLR_E_PROFIBUS_FSPMM_DMPMM_IV_STATE ((TLR_RESULT)0xC0380020L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM_PB_FLAG_ERROR_ACTION_FLAG
//
// MessageText:
//
//  Function 'AUTO CLEAR' not supported.
//
#define TLR_E_PROFIBUS_FSPMM_PB_FLAG_ERROR_ACTION_FLAG ((TLR_RESULT)0xC0380021L)    

//
// MessageId: TLR_E_PROFIBUS_FSPMM_PB_FLAG_ISO_MODE_MSK
//
// MessageText:
//
//  Function 'ISO_MODE' not supported.
//
#define TLR_E_PROFIBUS_FSPMM_PB_FLAG_ISO_MODE_MSK ((TLR_RESULT)0xC0380022L)    

//
// MessageId: TLR_E_PROFIBUS_FSPMM_DL_PB_FLAG_ISOM_SYNC
//
// MessageText:
//
//  Function 'ISO_MODE_SYNC' not supported.
//
#define TLR_E_PROFIBUS_FSPMM_DL_PB_FLAG_ISOM_SYNC ((TLR_RESULT)0xC0380023L)    

//
// MessageId: TLR_E_PROFIBUS_FSPMM_DL_PB_FLAG_ISOM_FREEZE
//
// MessageText:
//
//  Function 'ISO_MODE_FREEZE' not supported.
//
#define TLR_E_PROFIBUS_FSPMM_DL_PB_FLAG_ISOM_FREEZE ((TLR_RESULT)0xC0380024L)    

//
// MessageId: TLR_E_PROFIBUS_FSPMM_MSAC1_NRS
//
// MessageText:
//
//  Negative response received.
//
#define TLR_E_PROFIBUS_FSPMM_MSAC1_NRS   ((TLR_RESULT)0xC0380025L)    

//
// MessageId: TLR_E_PROFIBUS_FSPMM_MSALM_ALARM_ACK_NEG
//
// MessageText:
//
//  Negative alarm acknowledge response received.
//
#define TLR_E_PROFIBUS_FSPMM_MSALM_ALARM_ACK_NEG ((TLR_RESULT)0xC0380026L)    




#endif  //__PROFIBUS_FSPMM_ERROR_H

